/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import java.util.function.UnaryOperator;
import net.minecraft.class_2583;

public class BasicFormattingFeature
implements MarkdownFeature {
    private final boolean enableHorizontalRule;

    public BasicFormattingFeature(boolean enableHorizontalRule) {
        this.enableHorizontalRule = enableHorizontalRule;
    }

    public BasicFormattingFeature() {
        this(true);
    }

    @Override
    public String name() {
        return "basic_formatting";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken(Lexer.Token.lexFromChar(TildeToken::new), '~');
        registrar.registerToken(Lexer.Token.lexFromChar(UnderscoreToken::new), '_');
        registrar.registerToken((nibbler, tokens) -> {
            boolean rightAdjacent;
            int starCount = nibbler.consumeUntilEndOr(c -> c != '*').length();
            boolean leftAdjacent = !nibbler.expect(-starCount - 1, ' ');
            boolean bl = rightAdjacent = !nibbler.expect(0, ' ');
            if (starCount > 3 || !rightAdjacent && !leftAdjacent) {
                return false;
            }
            for (int i = 0; i < starCount; ++i) {
                tokens.add(new StarToken("*", leftAdjacent, rightAdjacent));
            }
            return true;
        }, '*');
        if (this.enableHorizontalRule) {
            registrar.registerToken((nibbler, tokens) -> {
                if (!nibbler.expect(-1, '\n') || !nibbler.expect(-2, '\n')) {
                    return false;
                }
                String dashes = nibbler.consumeUntilEndOr(c -> c != '-');
                if (dashes.length() != 3 || !nibbler.expect(0, '\n') || !nibbler.expect(1, '\n')) {
                    return false;
                }
                tokens.add(new HorizontalRuleToken());
                return true;
            }, '-');
        }
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        this.registerDoubleTokenFormatting(registrar, TildeToken.class, style -> style.method_36140(Boolean.valueOf(true)));
        this.registerDoubleTokenFormatting(registrar, UnderscoreToken.class, style -> style.method_30938(Boolean.valueOf(true)));
        registrar.registerNode((parser, left, tokens) -> {
            int pointer = tokens.pointer();
            Parser.Node content = parser.parseUntil(tokens, StarToken.class);
            Object patt2657$temp = tokens.peek();
            if (patt2657$temp instanceof StarToken) {
                StarToken right = (StarToken)patt2657$temp;
                if (right.leftAdjacent) {
                    tokens.nibble();
                    if (content instanceof StarNode) {
                        StarNode star = (StarNode)content;
                        if (star.canIncrementStarCount()) {
                            return star.incrementStarCount();
                        }
                        return new Parser.TextNode("*").addChild(content).addChild(new Parser.TextNode("*"));
                    }
                    return new StarNode().addChild(content);
                }
            }
            tokens.setPointer(pointer);
            return new Parser.TextNode(left.content());
        }, (token, tokens) -> {
            if (!(token instanceof StarToken)) return null;
            StarToken star = (StarToken)token;
            if (!star.rightAdjacent) return null;
            StarToken starToken = star;
            return starToken;
        });
        if (this.enableHorizontalRule) {
            registrar.registerNode((parser, rule, tokens) -> new HorizontalRuleNode(), (token, tokens) -> {
                HorizontalRuleToken rule;
                return token instanceof HorizontalRuleToken ? (rule = (HorizontalRuleToken)token) : null;
            });
        }
    }

    private <T extends Lexer.Token> void registerDoubleTokenFormatting(MarkdownFeature.NodeRegistrar registrar, Class<T> tokenClass, UnaryOperator<class_2583> formatting) {
        registrar.registerNode((parser, left1, tokens) -> {
            Lexer.Token left2 = (Lexer.Token)tokens.nibble();
            int pointer = tokens.pointer();
            Parser.Node content = parser.parseUntil(tokens, tokenClass);
            if (tokenClass.isInstance(tokens.peek()) && tokenClass.isInstance(tokens.peek(1))) {
                tokens.skip(2);
                return new Parser.FormattingNode(formatting).addChild(content);
            }
            tokens.setPointer(pointer);
            return new Parser.TextNode(left1.content() + left2.content());
        }, (token, tokens) -> tokenClass.isInstance(token) && tokenClass.isInstance(tokens.peek()) ? (Lexer.Token)tokenClass.cast(token) : null);
    }

    private static final class TildeToken
    extends Lexer.Token {
        public TildeToken() {
            super("~");
        }
    }

    private static final class UnderscoreToken
    extends Lexer.Token {
        public UnderscoreToken() {
            super("_");
        }
    }

    private static final class HorizontalRuleToken
    extends Lexer.Token {
        public HorizontalRuleToken() {
            super("---");
        }
    }

    private static class HorizontalRuleNode
    extends Parser.Node {
        private HorizontalRuleNode() {
        }

        @Override
        protected void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitHorizontalRule();
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }

    private static final class StarToken
    extends Lexer.Token {
        public final boolean leftAdjacent;
        public final boolean rightAdjacent;

        public StarToken(String content, boolean leftAdjacent, boolean rightAdjacent) {
            super(content);
            this.leftAdjacent = leftAdjacent;
            this.rightAdjacent = rightAdjacent;
        }
    }

    private static class StarNode
    extends Parser.FormattingNode {
        private int starCount = 1;

        public StarNode() {
            super(style -> style);
        }

        @Override
        protected class_2583 applyStyle(class_2583 style) {
            return style.method_10978(this.starCount % 2 == 1 ? Boolean.valueOf(true) : null).method_10982(this.starCount > 1 ? Boolean.valueOf(true) : null);
        }

        public StarNode incrementStarCount() {
            ++this.starCount;
            return this;
        }

        public boolean canIncrementStarCount() {
            return this.starCount < 3;
        }
    }
}

